/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;
import sonar.fluxnetworks.common.block.FluxControllerBlock;
import sonar.fluxnetworks.common.block.FluxPlugBlock;
import sonar.fluxnetworks.common.block.FluxPointBlock;
import sonar.fluxnetworks.common.block.FluxStorageBlock;
import sonar.fluxnetworks.common.capability.FluxPlayer;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.crafting.FluxStorageRecipeSerializer;
import sonar.fluxnetworks.common.crafting.NBTWipeRecipeSerializer;
import sonar.fluxnetworks.common.device.TileFluxController;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.device.TileFluxPlug;
import sonar.fluxnetworks.common.device.TileFluxPoint;
import sonar.fluxnetworks.common.device.TileFluxStorage;
import sonar.fluxnetworks.common.integration.TOPIntegration;
import sonar.fluxnetworks.common.item.FluxDeviceItem;
import sonar.fluxnetworks.common.item.FluxDustItem;
import sonar.fluxnetworks.common.item.FluxStorageItem;
import sonar.fluxnetworks.common.item.ItemAdminConfigurator;
import sonar.fluxnetworks.common.item.ItemFluxConfigurator;
import sonar.fluxnetworks.data.loot.FluxLootTableProvider;
import sonar.fluxnetworks.data.tags.FluxBlockTagsProvider;
import sonar.fluxnetworks.register.Channel;
import sonar.fluxnetworks.register.FMLChannel;
import sonar.fluxnetworks.register.MUIChannel;
import sonar.fluxnetworks.register.RegistryBlocks;
import sonar.fluxnetworks.register.RegistryItems;

@Mod.EventBusSubscriber(modid="fluxnetworks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Registration {
    public static final CreativeModeTab CREATIVE_MODE_TAB = new CreativeModeTab("fluxnetworks"){

        @Nonnull
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)RegistryItems.FLUX_CORE);
        }
    };

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        Channel.sChannel = FluxNetworks.isModernUILoaded() ? new MUIChannel() : new FMLChannel();
        event.enqueueWork(() -> ForgeChunkManager.setForcedChunkLoadingCallback((String)"fluxnetworks", (level, helper) -> {
            if (!FluxConfig.enableChunkLoading) {
                helper.getBlockTickets().keySet().forEach(arg_0 -> ((ForgeChunkManager.TicketHelper)helper).removeAllTickets(arg_0));
                FluxNetworks.LOGGER.info("Removed all chunk loaders because chunk loading is disabled");
            } else {
                int chunks = 0;
                for (Map.Entry entry : helper.getBlockTickets().entrySet()) {
                    BlockEntity patt3298$temp = level.m_7702_((BlockPos)entry.getKey());
                    if (patt3298$temp instanceof TileFluxDevice) {
                        TileFluxDevice e = (TileFluxDevice)patt3298$temp;
                        e.setForcedLoading(true);
                        Pair pair = (Pair)entry.getValue();
                        int count = 0;
                        count += ((LongSet)pair.getFirst()).size();
                        if ((count += ((LongSet)pair.getSecond()).size()) != 1) {
                            FluxNetworks.LOGGER.warn("{} in {} didn't load just one chunk {}", entry.getValue(), (Object)level.m_46472_().m_135782_(), (Object)pair);
                        }
                        chunks += count;
                        continue;
                    }
                    helper.removeAllTickets((BlockPos)entry.getKey());
                }
                FluxNetworks.LOGGER.info("Load {} chunks by {} flux devices in {}", (Object)chunks, (Object)helper.getBlockTickets().size(), (Object)level.m_46472_().m_135782_());
            }
        }));
    }

    @SubscribeEvent
    public static void enqueueIMC(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("carryon")) {
            InterModComms.sendTo((String)"carryon", (String)"blacklistBlock", () -> "fluxnetworks:*");
        }
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPIntegration::new);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(@Nonnull RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        BlockBehaviour.Properties normalProps = BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60913_(1.0f, 1000.0f);
        BlockBehaviour.Properties deviceProps = BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60913_(1.0f, 1000.0f).m_60955_();
        registry.register((IForgeRegistryEntry)((Block)new Block(normalProps).setRegistryName("flux_block")));
        registry.register((IForgeRegistryEntry)((Block)new FluxPlugBlock(deviceProps).setRegistryName("flux_plug")));
        registry.register((IForgeRegistryEntry)((Block)new FluxPointBlock(deviceProps).setRegistryName("flux_point")));
        registry.register((IForgeRegistryEntry)((Block)new FluxControllerBlock(deviceProps).setRegistryName("flux_controller")));
        registry.register((IForgeRegistryEntry)((Block)new FluxStorageBlock.Basic(deviceProps).setRegistryName("basic_flux_storage")));
        registry.register((IForgeRegistryEntry)((Block)new FluxStorageBlock.Herculean(deviceProps).setRegistryName("herculean_flux_storage")));
        registry.register((IForgeRegistryEntry)((Block)new FluxStorageBlock.Gargantuan(deviceProps).setRegistryName("gargantuan_flux_storage")));
    }

    @SubscribeEvent
    public static void registerItems(@Nonnull RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        Item.Properties props = new Item.Properties().m_41491_(CREATIVE_MODE_TAB).m_41486_();
        registry.register((IForgeRegistryEntry)((Item)new BlockItem(RegistryBlocks.FLUX_BLOCK, props).setRegistryName("flux_block")));
        registry.register((IForgeRegistryEntry)((Item)new FluxDeviceItem(RegistryBlocks.FLUX_PLUG, props).setRegistryName("flux_plug")));
        registry.register((IForgeRegistryEntry)((Item)new FluxDeviceItem(RegistryBlocks.FLUX_POINT, props).setRegistryName("flux_point")));
        registry.register((IForgeRegistryEntry)((Item)new FluxDeviceItem(RegistryBlocks.FLUX_CONTROLLER, props).setRegistryName("flux_controller")));
        registry.register((IForgeRegistryEntry)((Item)new FluxStorageItem(RegistryBlocks.BASIC_FLUX_STORAGE, props).setRegistryName("basic_flux_storage")));
        registry.register((IForgeRegistryEntry)((Item)new FluxStorageItem(RegistryBlocks.HERCULEAN_FLUX_STORAGE, props).setRegistryName("herculean_flux_storage")));
        registry.register((IForgeRegistryEntry)((Item)new FluxStorageItem(RegistryBlocks.GARGANTUAN_FLUX_STORAGE, props).setRegistryName("gargantuan_flux_storage")));
        registry.register((IForgeRegistryEntry)((Item)new FluxDustItem(props).setRegistryName("flux_dust")));
        registry.register((IForgeRegistryEntry)((Item)new Item(props).setRegistryName("flux_core")));
        Item.Properties toolProps = new Item.Properties().m_41491_(CREATIVE_MODE_TAB).m_41486_().m_41487_(1);
        registry.register((IForgeRegistryEntry)((Item)new ItemFluxConfigurator(toolProps).setRegistryName("flux_configurator")));
        registry.register((IForgeRegistryEntry)((Item)new ItemAdminConfigurator(toolProps).setRegistryName("admin_configurator")));
    }

    @SubscribeEvent
    public static void registerBlockEntities(@Nonnull RegistryEvent.Register<BlockEntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)((BlockEntityType)new BlockEntityType(TileFluxPlug::new, Set.of(RegistryBlocks.FLUX_PLUG), DSL.remainderType()).setRegistryName("flux_plug")));
        registry.register((IForgeRegistryEntry)((BlockEntityType)new BlockEntityType(TileFluxPoint::new, Set.of(RegistryBlocks.FLUX_POINT), DSL.remainderType()).setRegistryName("flux_point")));
        registry.register((IForgeRegistryEntry)((BlockEntityType)new BlockEntityType(TileFluxController::new, Set.of(RegistryBlocks.FLUX_CONTROLLER), DSL.remainderType()).setRegistryName("flux_controller")));
        registry.register((IForgeRegistryEntry)((BlockEntityType)new BlockEntityType(TileFluxStorage.Basic::new, Set.of(RegistryBlocks.BASIC_FLUX_STORAGE), DSL.remainderType()).setRegistryName("basic_flux_storage")));
        registry.register((IForgeRegistryEntry)((BlockEntityType)new BlockEntityType(TileFluxStorage.Herculean::new, Set.of(RegistryBlocks.HERCULEAN_FLUX_STORAGE), DSL.remainderType()).setRegistryName("herculean_flux_storage")));
        registry.register((IForgeRegistryEntry)((BlockEntityType)new BlockEntityType(TileFluxStorage.Gargantuan::new, Set.of(RegistryBlocks.GARGANTUAN_FLUX_STORAGE), DSL.remainderType()).setRegistryName("gargantuan_flux_storage")));
    }

    @SubscribeEvent
    public static void registerMenus(@Nonnull RegistryEvent.Register<MenuType<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)((MenuType)IForgeMenuType.create((containerId, inventory, buffer) -> {
            if (buffer.readBoolean()) {
                BlockPos pos = buffer.m_130135_();
                BlockEntity patt10221$temp = inventory.f_35978_.m_183503_().m_7702_(pos);
                if (patt10221$temp instanceof TileFluxDevice) {
                    TileFluxDevice device = (TileFluxDevice)patt10221$temp;
                    CompoundTag tag = buffer.m_130260_();
                    if (tag != null) {
                        device.readCustomTag(tag, (byte)11);
                    }
                    return new FluxMenu(containerId, inventory, device);
                }
            } else {
                ItemStack stack = inventory.f_35978_.m_21205_();
                if (stack.m_41720_() == RegistryItems.FLUX_CONFIGURATOR) {
                    return new FluxMenu(containerId, inventory, new ItemFluxConfigurator.Provider(stack));
                }
            }
            return new FluxMenu(containerId, inventory, new ItemAdminConfigurator.Provider());
        }).setRegistryName("flux_menu")));
    }

    @SubscribeEvent
    public static void registerRecipes(@Nonnull RegistryEvent.Register<RecipeSerializer<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)FluxStorageRecipeSerializer.INSTANCE.setRegistryName("flux_storage_recipe")));
        event.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)NBTWipeRecipeSerializer.INSTANCE.setRegistryName("nbt_wipe_recipe")));
    }

    @SubscribeEvent
    public static void registerSounds(@Nonnull RegistryEvent.Register<SoundEvent> event) {
        ResourceLocation soundID = new ResourceLocation("fluxnetworks", "button");
        event.getRegistry().register((IForgeRegistryEntry)((SoundEvent)new SoundEvent(soundID).setRegistryName(soundID)));
    }

    @SubscribeEvent
    public static void registerCapabilities(@Nonnull RegisterCapabilitiesEvent event) {
        event.register(FluxPlayer.class);
        event.register(IFNEnergyStorage.class);
    }

    @SubscribeEvent
    public static void gatherData(@Nonnull GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new FluxLootTableProvider(generator));
            generator.m_123914_((DataProvider)new FluxBlockTagsProvider(generator, event.getExistingFileHelper()));
        }
    }
}

